/*
     .               .      : 
, symperasma(X,Y)
, symptom(C,B).
, arrostia(G).

     '             .
..      
symperasma(ipnilia,arketa):- symptom(pyreto,poly).

        . ,          ,      '           (   ).

symptom(X,Y):-
arnitiki(X,Y),
!,
fail.

symptom(X,Y):-
gnosto(X,Y),
!.

symptom(X,Y):-
symperasma(X,Y),
!.

       ,     ,        .     ,   ( )   . 

symptom(X,W):-
write('Exoume '), 
write(W),
write(' '), 
write(X),
write(' (y/n); '), 
read(y),
!,
assert(gnosto(X,W)).

         read         y.    .
     (      y.,   )        (        '   )       . 
                  ' .             '   .

symptom(X,Y):-
assert(arnitiki(X,Y)),
fail.

         .. 
.. :
arrostia(monopirinosi):-
symptom(adenes,prismeni),
symptom(kourasi,arketa), 
symptom(ipnilia,arketa).
                .

arrostia(vronxitida):-
arrostia(kriologima),
symptom(bixa,poly).
              . 
*/

symperasma(X,arketa):-
symptom(X,poly),
!.
symperasma(ponolaimos,arketa):-
symptom(bixa,arketa),
!.

symperasma(kourasi,arketa):-
symptom(pyreto,poly),
!.

symperasma(ipnilia,arketa):-
symptom(pyreto,poly).

/*-------------------------*/
symptom(X,Y):-
arnitiki(X,Y),
!,
fail.

symptom(X,Y):-
gnosto(X,Y),
!.

symptom(X,Y):-
symperasma(X,Y),
!.

symptom(X,W):-
write('Exoume '), 
write(W),
write(' '), 
write(X),
write(' (y/n); '), 
read(y),
!,
assert(gnosto(X,W)).

symptom(X,Y):-
assert(arnitiki(X,Y)),
fail.

/*-------------------*/

arrostia(kriologima):-
symptom(pyreto,arketa), 
symptom(ponolaimos,arketa), 
symptom(bixa,arketa).

arrostia(kriologima):-
symptom(kourasi,arketa),
symptom(miti,treei).

arrostia(kriologima):-
symptom(diarroia,arketa), 
symptom(pyreto,arketa).

/*-------------------*/

arrostia(ilara):-
symptom(spirakia,poly),
symptom(pyreto,_).

/*-------------------*/

arrostia(ipatitida):-
symptom(derma,kitrino),
symptom(oura,kokkina).

/*-------------------*/

arrostia(lariggitida):-
not(symptom(pyreto,_)), 
symptom(bia,poly), 
symptom(ponolaimos,poly).

/*-------------------*/

arrostia(monopirinosi):-
symptom(adenes,prismeni),
symptom(kourasi,arketa),
symptom(ipnilia,arketa).

/*-------------------*/

arrostia(kokkitis):-
symptom(bia,poly),
symptom(ponolaimos,poly),
symptom(pyreto,arketa).

/*-------------------*/

arrostia(elonosia):-
symptom(ipnilia,poly),
symptom(pyreto,poly).

/*-------------------*/

arrostia(anafilaxia):-
not(symptom(pyreto,_)), 
symptom(spirakia,poly).

/*-------------------*/

arrostia(anemia):-
symptom(kourasi,poly), 
symptom(adenes,prismeni),
symptom(derma,kitrino).

/*-------------------*/

arrostia(vronxitida):-
arrostia(kriologima),
symptom(bixa,poly).

/*-------------------*/

arrostia(dilitiriasi):-
not(arrostia(kriologima)), 
symptom(diarroia,poly).

/*-------------------*/

go(X):-
assert(arnitiki(_,_)), 
assert(gnosto(_,_)),
retractall(gnosto(_,_)), 
retractall(arnitiki(_,_)),
arrostia(X).
